pro time, start_time, stop_time

;+
; TIME
;       Select start and stop times for plotting data.
;
; Call:
;       time[, start_time, stop_time]
;
; Arguments:
;	start_time	int	input	4-element array with start time
;					[y,d,h,m]
;	stop_time	int	input	4-element array with end time.
;
; Common values used:
;       tstart  int     output  4-element array containing the start time
;                               as year, day, hours, minutes
;       tstop   int     output  4-element array containing the stop time in the
;                               same format.
;
; History:
;       Prototype: 29/1/91; SJT
;       Moved time limits to common: 7/2/91; SJT
;       Previous times held as default: 26/3/91; SJT
;	Replotting lock: 13/9/91; SJT
;	Add CDF replot flag: 15/11/91; SJT
;	Add SPC replot flag: 6/3/92; SJT
;	Add PAD replot flag: 15/4/92; SJT
;	Add B replot flag: 27/4/92; SJT
;	Add UDS replot_flag: 4/11/94; SJT
;	Add PHA replot flag: 21/11/95; SJT
;-
common time_limits, tstart, tstop, y0, d0, hstart
; @time_limits
@flags
@cdf_flags
@spec_flags
@pad_flags
@b_flags
@uds_flags
@pha_flags

np = n_params()
if n_elements(tstart) eq 0 then tstart = (tstop = intarr(4))

get_time:
if (np eq 0) then begin
    st = ''
    read, 'Enter start time (y,d,h,m) [separated by commas] <' + $
           string(tstart, format="(i2,',',i3,',',i2,',',i2)") + '> :_', st

    if st ne '' then begin
	tstart = conv_time_str(st)
	hstart = hours(tstart(0:1),[90,318])
	spc_replot_ok = 0
	cdf_replot_ok = 0
	pad_replot_ok = 0
        b_replot_ok = 0
        uds_replot_ok = 0
        pha_replot_ok = 0
	replot_ok = 0
    endif

    st = ''
    read, 'Enter stop time (y,d,h,m) [separated by commas] <' + $
           string(tstop, format="(i2,',',i3,',',i2,',',i2)") + '> :_', st

    if st eq '' then return
    tstop = conv_time_str(st)
    replot_ok = 0
    b_replot_ok = 0
    cdf_replot_ok = 0
    spc_replot_ok = 0
    pad_replot_ok = 0
    pha_replot_ok = 0
    uds_replot_ok = 0
endif else if (np eq 2) then begin
    tstart(*) = 0
    tstop(*)  = 0
    tstart(0) = norm_time(start_time)
    tstop(0) = norm_time(stop_time)
    hstart = hours(tstart(0:1),[90,318])
    replot_ok = 0
    b_replot_ok = 0
    cdf_replot_ok = 0
    spc_replot_ok = 0
    pad_replot_ok = 0
    pha_replot_ok = 0
    uds_replot_ok = 0
endif else begin
    print, 'Must give 0 or 2 arguments.'
    np = 0
    goto, get_time
endelse

if (compare_times(tstart, tstop) ge 0) then begin
    hs_err_msg, 'End time must be greater than start time.'
    np = 0
    goto, get_time
endif

return
end
